using System;
using System.Threading;

namespace Implab.Parallels {
    public class ThreadPoolDispatcher : IDispatcher {

        public static ThreadPoolDispatcher Instance { get; private set; } = new ThreadPoolDispatcher();

        private ThreadPoolDispatcher() {
        }

        public void Enqueue(Action job) {
            ThreadPool.QueueUserWorkItem((o) => job(), null);
        }

        public void Enqueue<T>(Action<T> job, T arg) {
            ThreadPool.QueueUserWorkItem((o) => job((T)o), arg);
        }
    }
}