﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Diagnostics {
    public static class Log {
        [Conditional("TRACE")]
        public static void Transfer(LogContext from) {
            LogContext.Transfer(from);
        }

        [Conditional("TRACE")]
        public static void StartLogicalOperation() {
            LogContext.Current.StartLogicalOperation();
        }

        [Conditional("TRACE")]
        public static void StartLogicalOperation(string name) {
            LogContext.Current.StartLogicalOperation(name);
        }

        [Conditional("TRACE")]
        public static void EndLogicalOperation() {
            LogContext.Current.EndLogicalOperation();
        }

        [Conditional("TRACE")]
        public static void TraceInformation(string format, params object[] arguments) {
            LogContext.Current.TraceEvent(TraceEventType.Information, format, arguments);
        }

        [Conditional("TRACE")]
        public static void TraceWarning(string format, params object[] arguments) {
            LogContext.Current.TraceEvent(TraceEventType.Warning, format, arguments);
        }

        [Conditional("TRACE")]
        public static void TraceError(string format, params object[] arguments) {
            LogContext.Current.TraceEvent(TraceEventType.Error, format, arguments);
        }

        [Conditional("TRACE")]
        public static void TraceError(Exception err) {
            TraceError("{0}", err);
        }
    }
}
