﻿using System;

namespace Implab {
    public class ActionChainTask : ActionChainTaskBase, IDeferred {
        readonly Func<IPromise> m_task;

        public ActionChainTask(Func<IPromise> task, Func<Exception, IPromise> error, Func<Exception, IPromise> cancel, bool autoCancellable) : base(error,cancel, autoCancellable) {
            m_task = task;
        }

        public void Resolve() {
            if (m_task != null && LockCancelation()) {
                try {
                    var p = m_task();
                    p.On(SetResult, HandleErrorInternal, SetCancelled);
                    CancellationRequested(p.Cancel);
                } catch(Exception err) {
                    HandleErrorInternal(err);
                }
            }
        }

    }
}

