﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Parsing {
    /// <summary>
    /// Алфавит. Множество символов, которые разбиты на классы, при этом классы имеют непрерывную нумерацию,
    /// что позволяет использовать их в качестве индексов массивов.
    /// </summary>
    /// <remarks>
    /// <para>Алфавит является сюрьективным отображением множества символов в множество индексов, это позволяет сократить размер таблицы переходов автомата
    /// для входных символов, которые для него не различимы.</para>
    /// </remarks>
    /// <typeparam name="TSymbol">Тип символов.</typeparam>
    public interface IAlphabet<TSymbol> {
        /// <summary>
        /// Количество классов символов в алфавите.
        /// </summary>
        int Count { get; }

        /// <summary>
        /// Создает карту обратного сопоставления класса символов алфавита и сопоставленным
        /// ему исходным символам.
        /// </summary>
        /// <returns></returns>
        List<TSymbol>[] CreateReverseMap();

        /// <summary>
        /// Создает новый алфавит на основе текущего, горппируя его сиволы в более
        /// крупные непересекающиеся классы символов.
        /// </summary>
        /// <param name="newAlphabet">Новый, пустой алфавит, в котором быдут определены классы.</param>
        /// <param name="classes">Множество классов символов текущего алфавита.</param>
        /// <returns>Карта для перехода классов текущего
        /// алфавита к классам нового.</returns>
        /// <remarks>Ползволяет укрупнить алфавит, объединив классы в текущем алфавите. Используется при оптимизации автомата.</remarks>
        int[] Reclassify(IAlphabetBuilder<TSymbol> newAlphabet, IEnumerable<ICollection<int>> classes);

        /// <summary>
        /// Преобразует входной символ в индекс символа из алфавита.
        /// </summary>
        /// <param name="symobl">Исходный символ</param>
        /// <returns>Индекс в алфавите</returns>
        int Translate(TSymbol symobl);
    }
}
