﻿using System;
using System.Collections.Generic;

namespace Implab.Parsing {
    public interface IAlphabetBuilder<TSymbol> : IAlphabet<TSymbol> {
        /// <summary>
        /// Добавляет новый символ в алфавит, если символ уже был добавлен, то
        /// возвращается ранее сопоставленный с символом класс.
        /// </summary>
        /// <param name="symbol">Символ для добавления.</param>
        /// <returns>Индекс класса, который попоставлен с символом.</returns>
        int DefineSymbol(TSymbol symbol);
        /// <summary>
        /// Доабвляем класс символов. Множеству указанных исходных символов 
        /// будет сопоставлен символ в алфавите.
        /// </summary>
        /// <param name="symbols">Множестов исходных символов</param>
        /// <returns>Идентификатор символа алфавита.</returns>
        int DefineClass(IEnumerable<TSymbol> symbols);



    }
}

