﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Implab.Diagnostics {
    public class LogChannel<TEvent> {
        static LogChannel<TEvent> _default = new LogChannel<TEvent>();

        public static LogChannel<TEvent> Default {
            get {
                return _default;
            }
        }

        public event EventHandler<ValueEventArgs<TEvent>> Events;

        public void LogEvent(TEvent data) {
            var t = Events;
            if (t!= null)
                t(TraceContext.Current,new ValueEventArgs<TEvent>(data));
        }
    }
}
