﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Implab.Diagnostics {
    public class TraceEvent {
        public string Message {
            get;
            private set;
        }

        public TraceEventType EventType {
            get;
            private set;
        }

        public TraceEvent(TraceEventType type, string message) {
            EventType = type;
            Message = message;
        }

        public static TraceEvent Create(TraceEventType type, string format, params object[] args) {
            return new TraceEvent(type, String.Format(format, args));
        }
    }
}
