﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Linq;

namespace Implab.Xml {
    public static class SerializationHelpers {
        public static string SerializeAsString<T>(T obj) {
            return SerializersPool<T>.Instance.SerializeAsString(obj);
        }

        public static void Serialize<T>(XmlWriter writer, T obj) {
            SerializersPool<T>.Instance.Serialize(writer, obj);
        }

        public static XmlDocument SerializeAsXmlDocument<T>(T obj) {
            var doc = new XmlDocument();
            using (var writer = doc.CreateNavigator().AppendChild()) {
                SerializersPool<T>.Instance.Serialize(writer, obj);
            }
            return doc;
        }

        public static XDocument SerializeAsXDocument<T>(T obj) {
            var doc = new XDocument();
            using (var writer = doc.CreateWriter()) {
                SerializersPool<T>.Instance.Serialize(writer, obj);
            }
            return doc;
        }

        public static void SerializeToFile<T>(string file, T obj) {
            using (var writer = File.CreateText(file))
                SerializersPool<T>.Instance.Serialize(writer, obj);
        }

        public static void SerializeToElementChild<T>(XmlElement element, T obj) {
            using(var writer = element.CreateNavigator().AppendChild())
                SerializersPool<T>.Instance.Serialize(writer, obj);
        }

        public static T Deserialize<T>(XmlReader reader) {
            return SerializersPool<T>.Instance.Deserialize(reader);
        }

        public static T DeserializeFromFile<T>(string file) {
            using(var reader = XmlReader.Create(File.OpenText(file)))
                return Deserialize<T>(reader);
        }

        public static T DeserializeFromString<T>(string data) {
            return SerializersPool<T>.Instance.DeserializeFromString(data);
        }

        public static T DeserializeFromXmlNode<T>(XmlNode node) {
            Safe.ArgumentNotNull(node, nameof(node));
            using (var reader = node.CreateNavigator().ReadSubtree())
                return SerializersPool<T>.Instance.Deserialize(reader);
        }
    }
}
