using System;

namespace Implab
{
    public struct RejectedPromise : IPromise {
        readonly Exception m_reason;

        public Type ResultType => typeof(void);

        public bool IsResolved => true;

        public bool IsRejected => true;

        public bool IsFulfilled => false;

        public Exception RejectReason => m_reason;

        public RejectedPromise(Exception reason) {
            m_reason = reason;
        }

        public IPromise<T> Cast<T>() {
            throw new InvalidCastException();
        }

        public void Join() {
            throw m_reason.Wrap();
        }

        public void Join(int timeout) {
            throw m_reason.Wrap();
        }

        public void Then(IResolvable next) {
            next.Reject(m_reason);
        }
    }
}