﻿using System.Threading;

namespace Implab {
    public static class PromiseExtensions {
        public static IPromise<T> DispatchToCurrentContext<T>(this IPromise<T> that) {
            var context = SynchronizationContext.Current;
            if (context == null)
                return that;

            var p = new SyncContextPromise<T>(context, that, true);

            that.Then(
                x => p.Resolve(x),
                e => {
                    p.Reject(e);
                    return default(T);
                }
            );
            return p;
        }

        public static IPromise<T> DispatchToContext<T>(this IPromise<T> that, SynchronizationContext context) {
            Safe.ArgumentNotNull(context, "context");

            var p = new SyncContextPromise<T>(context, that, true);

            that.Then(
                x => p.Resolve(x),
                e => {
                    p.Reject(e);
                    return default(T);
                }
            );
            return p;
        }
    }
}

