﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Implab.Diagnostics {
    public class TraceEvent {
        public string Message {
            get;
            private set;
        }

        public TraceEventType EventType {
            get;
            private set;
        }

        public TraceEvent(TraceEventType type, string message) {
            EventType = type;
            Message = message;
        }

        public override string ToString() {
            return String.Format("{0}: {1}", EventType, Message);
        }

        public static TraceEvent Create(TraceEventType type, string format, params object[] args) {
            return new TraceEvent(type, String.Format(format ?? String.Empty, args));
        }
    }
}
