﻿using System;
using Implab.Parallels;

namespace Implab {
    public class Promise : AbstractPromise, IDeferred {
        public static readonly IPromise Success;

        static Promise() {
            Success = new SuccessPromise();
        }

        public void Resolve() {
            SetResult();
        }

        public void Reject(Exception error) {
            SetError(error);
        }

        public static IPromise FromException(Exception exception) {
            return new FailedPromise(exception);
        }
    }
}

