﻿using Implab.Automaton;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Formats {
    public class CharMap : IAlphabet<char> {
        readonly char m_min;
        readonly char m_max;
        readonly int[] m_map;

        public CharMap(char min, int[] map) {
            Safe.ArgumentNotNull(map, nameof(map));
            Count = map.Max()+1;
            m_min = min;
            m_map = map;
            m_max = (char)(min + map.Length);
        }

        public int Count {
            get; private set;
        }

        public bool Contains(char symbol) {
            return symbol >= m_min && symbol <= m_max && m_map[symbol-m_min] != AutomatonConst.UNCLASSIFIED_INPUT;
        }

        public IEnumerable<char> GetSymbols(int cls) {
            for (var i = 0; i < m_map.Length; i++)
                if (m_map[i] == cls)
                    yield return (char)(i + m_min);
        }

        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        public int Translate(char symbol) {
            return symbol >= m_min && symbol <= m_max ? m_map[symbol-m_min] : AutomatonConst.UNCLASSIFIED_INPUT;
        }
    }
}
