﻿using Implab.Formats.Json;
using Implab.Xml;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Serialization;

namespace Implab.Playground {
    public class Program {

        [XmlRoot(Namespace = "XmlSimpleData")]
        public class XmlSimpleModel {
            [XmlElement]
            public string Name { get; set; }

            [XmlElement]
            public int Order { get; set; }

            [XmlElement]
            public string[] Items { get; set; }

        }

        static void Main(string[] args) {
            var model = new XmlSimpleModel {
                Name = "Tablet",
                Order = 10,
                Items = new string[] { "z1", "z2", "z3" }
            };

            var doc = SerializationHelpers.SerializeAsXmlDocument(model);

            var m2 = SerializationHelpers.DeserializeFromXmlNode<XmlSimpleModel>(doc.DocumentElement);

            Console.WriteLine("done");
        }
    }
}
