﻿using System;

namespace Implab.Diagnostics {
    public class TraceEvent {
        public string Message {
            get;
            private set;
        }

        public TraceEventType EventType {
            get;
            private set;
        }

        /// <summary>
        /// The logical operation this event belongs to.
        /// </summary>
        public LogicalOperation Operation {
            get;
            private set;
        }

        /// <summary>
        /// Gets the time offset in milliseconds from the start of the operation, if the operation is not specified the value is zero.
        /// </summary>
        public int OperationTime {
            get;
            private set;
        }

        public TraceEvent(LogicalOperation operation, TraceEventType type, string message) {
            EventType = type;
            Message = message;
            Operation = operation;
            if (operation != null)
                OperationTime = operation.Duration;
        }

        public override string ToString() {
            return Message;
        }

        public static TraceEvent Create(LogicalOperation operation, TraceEventType type, string format, params object[] args) {
            return new TraceEvent(operation, type, format == null ? String.Empty : args == null || args.Length == 0 ? format : String.Format(format, args));
        }
    }
}
