﻿using System;

namespace Implab {
    public class FuncTaskBase<TResult> : AbstractTask<TResult> {
        readonly Func<Exception, TResult> m_cancel;
        readonly Func<Exception, TResult> m_error;

        protected FuncTaskBase( Func<Exception, TResult> error, Func<Exception, TResult> cancel, bool autoCancellable) {
            m_error = error;
            m_cancel = cancel;
            if (autoCancellable)
                CancellationRequested(CancelOperation);
        }

        public void Reject(Exception error) {
            Safe.ArgumentNotNull(error, "error");
            if (LockCancelation())
                HandleErrorInternal(error);
        }

        protected void HandleErrorInternal(Exception error) {
            if (m_error != null) {
                try {
                    SetResult(m_error(error));
                } catch(Exception err) {
                    SetErrorInternal(err);
                }
            } else {
                SetErrorInternal(error);
            }
        }

        public override void CancelOperation(Exception reason) {
            if (LockCancelation())
                HandleCancelInternal(reason);
        }

        protected void HandleCancelInternal(Exception reason) {
            if (m_cancel != null) {
                try {
                    SetResult(m_cancel(reason));
                } catch (Exception err) {
                    SetErrorInternal(err);
                }
            } else {
                SetCancelledInternal(reason);
            }
        }

    }
}

