﻿using Implab;

namespace Implab.Automaton.RegularExpressions {
    /// <summary>
    /// Выражение, соответсвующее одному символу.
    /// </summary>
    public class SymbolToken<TTag> : Token<TTag> {
        int m_value;

        public int Value {
            get { return m_value; }
        }

        public SymbolToken(int value) {
            m_value = value;
        }
        public override void Accept(IVisitor<TTag> visitor) {
            Safe.ArgumentNotNull(visitor, "visitor");

            visitor.Visit(this);
        }

        public override string ToString() {
            return Value.ToString();
        }
    }
}
