﻿
namespace Implab.Automaton {
    /// <summary>
    /// Полностью описывает DFA автомат, его поведение, состояние и входные символы.
    /// </summary>
    /// <example>
    /// class MyAutomaton {
    ///     int m_current;
    ///     readonly DFAStateDescriptor<string>[] m_automaton;
    ///     readonly IAlphabet<MyCommands> m_commands;
    /// 
    ///     public MyAutomaton(IDFADefinition&lt;MyCommands,MyStates,string&gt; definition) {
    ///         m_current = definition.StateAlphabet.Translate(MyStates.Initial);
    ///         m_automaton = definition.GetTransitionTable();
    ///         m_commands = definition.InputAlphabet;
    ///     }
    /// 
    ///     // defined a method which will move the automaton to the next state
    ///     public void Move(MyCommands cmd) {
    ///         // use transition map to determine the next state
    ///         var next = m_automaton[m_current].transitions[m_commands.Translate(cmd)];
    /// 
    ///         // validate that we aren't in the unreachable state
    ///         if (next == DFAConst.UNREACHABLE_STATE)
    ///             throw new InvalidOperationException("The specified command is invalid");
    /// 
    ///         // if everything is ok
    ///         m_current = next;
    ///     }
    /// }
    /// </example>
    public interface IDFADefinition<TInput, TState, TTag> {
        /// <summary>
        /// Алфавит входных символов
        /// </summary>
        /// <value>The input alphabet.</value>
        IAlphabet<TInput> InputAlphabet {
            get;
        }

        /// <summary>
        /// Алфавит состояний автомата
        /// </summary>
        /// <value>The state alphabet.</value>
        IAlphabet<TState> StateAlphabet {
            get;
        }

        /// <summary>
        /// Таблица переходов состояний автомата
        /// </summary>
        /// <returns>The transition table.</returns>
        DFAStateDescriptior<TTag>[] GetTransitionTable();

    }
}
