﻿namespace Implab.Automaton {
    public class CDFADefinition : DFADefinition {
        readonly CharAlphabet m_alphabet;

        public CharAlphabet Alphabet {
            get { return m_alphabet; }
        }

        public CDFADefinition(CharAlphabet alphabet): base(alphabet.Count) {
            m_alphabet = alphabet;
        }

        public CDFADefinition Optimize() {
            
            return (CDFADefinition)Optimize(alphabet => new CDFADefinition((CharAlphabet)alphabet), m_alphabet, new CharAlphabet());
        }

        public void PrintDFA() {
            PrintDFA(m_alphabet);
        }
    }
}
