﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Diagnostics {
    /// <summary>
    /// This class is used to trace a logical flow of the application, it publishes events to the default <see cref="TraceEvent"/> channel.
    /// </summary>
    public static class TraceLog {
        /// <summary>
        /// Starts the logical operation nested to the current operation nested to the current one.
        /// </summary>
        [Conditional("TRACE")]
        public static void StartLogicalOperation() {
            TraceContext.Instance.StartLogicalOperation();

        }

        /// <summary>
        /// Starts the logical operation with the specified name, this name is usefull in logs.
        /// </summary>
        /// <param name="name">Name.</param>
        [Conditional("TRACE")]
        public static void StartLogicalOperation(string name) {
            TraceContext.Instance.StartLogicalOperation(name);
        }

        /// <summary>
        /// Ends the logical operation and restores the previous one.
        /// </summary>
        [Conditional("TRACE")]
        public static void EndLogicalOperation() {
            var op = TraceContext.Instance.EndLogicalOperation();
            LogChannel<TraceEvent>.Default.LogEvent(new TraceEvent(TraceEventType.OperationCompleted, String.Format("-{0} : {1}ms",op.Name, op.Duration)));
        }

        /// <summary>
        /// Writes an informational message.
        /// </summary>
        /// <param name="format">Format.</param>
        /// <param name="arguments">Arguments.</param>
        [Conditional("TRACE")]
        public static void TraceInformation(string format, params object[] arguments) {
            LogChannel<TraceEvent>.Default.LogEvent(TraceEvent.Create(TraceEventType.Information, format, arguments));
        }

        /// <summary>
        /// Writes a warning message.
        /// </summary>
        /// <param name="format">Format.</param>
        /// <param name="arguments">Arguments.</param>
        [Conditional("TRACE")]
        public static void TraceWarning(string format, params object[] arguments) {
            LogChannel<TraceEvent>.Default.LogEvent(TraceEvent.Create(TraceEventType.Warning, format, arguments));
        }

        [Conditional("TRACE")]
        public static void TraceError(string format, params object[] arguments) {
            LogChannel<TraceEvent>.Default.LogEvent(TraceEvent.Create(TraceEventType.Error, format, arguments));
        }

        [Conditional("TRACE")]
        public static void TraceError(Exception err) {
            TraceError("{0}", err);
        }
    }
}
