﻿using System;
using Implab;
using System.Threading.Tasks;
using Implab.Formats.JSON;
using System.IO;
using System.Text.Json;
using System.Diagnostics;
using Implab.Parallels;
using System.Threading;

namespace MonoPlay {
    class MainClass {


        public static void Main(string[] args) {
            var pool = new WorkerPool(10);

            var listerner = new ConsoleTraceListener();
            listerner.TraceOutputOptions = TraceOptions.LogicalOperationStack;
            Trace.Listeners.Add(listerner);

            Trace.CorrelationManager.StartLogicalOperation("Main");

            var d = pool.Invoke(() => {
                Trace.CorrelationManager.StartLogicalOperation("Worker");
                Thread.Sleep(100);
                Trace.TraceInformation("worker done");
                Trace.CorrelationManager.StopLogicalOperation();
            });

            ThreadPool.QueueUserWorkItem((o) => {
                Trace.CorrelationManager.StartLogicalOperation("Thread");
                Thread.Sleep(100);
                Trace.TraceInformation("thread done");
                Trace.CorrelationManager.StopLogicalOperation();
            });

            Trace.TraceInformation("main done");
            Trace.CorrelationManager.StopLogicalOperation();

            d.Join();



        }

    }
}
