﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Implab {
    public interface IPromise<T>: IPromise {

        new T Join();

        new T Join(int timeout);

        IPromise<T> Then(ResultHandler<T> success, ErrorHandler<T> error, Action cancel);

        IPromise<T> Then(ResultHandler<T> success, ErrorHandler<T> error);

        IPromise<T> Then(ResultHandler<T> success);

        void Last(ResultHandler<T> success, ErrorHandler error, Action cancel);
        void Last(ResultHandler<T> success, ErrorHandler error);
        void Last(ResultHandler<T> success);

        IPromise<T> Error(ErrorHandler<T> error);

        IPromise<T2> Then<T2>(ResultMapper<T,T2> mapper, ErrorHandler<T> error);

        IPromise<T2> Then<T2>(ResultMapper<T,T2> mapper);

        IPromise<T2> Then<T2>(ChainedOperation<T, T2> chained, ErrorHandler<T> error);

        IPromise<T2> Then<T2>(ChainedOperation<T, T2> chained);

        new IPromise<T> Cancelled(Action handler);

        new IPromise<T> Finally(Action handler);
    }
}
