﻿using System.Threading;
using System;
#if NET_4_5
using System.Threading.Tasks;
#endif

namespace Implab {
    public static class PromiseExtensions {
        public static IPromise<T> DispatchToCurrentContext<T>(this IPromise<T> that) {
            Safe.ArgumentNotNull(that, "that");
            var context = SynchronizationContext.Current;
            if (context == null)
                return that;

            var p = new SyncContextPromise<T>(context, that, true);

            that.Then(
                x => p.Resolve(x),
                e => {
                    p.Reject(e);
                    return default(T);
                }
            );
            return p;
        }

        public static IPromise<T> DispatchToContext<T>(this IPromise<T> that, SynchronizationContext context) {
            Safe.ArgumentNotNull(that, "that");
            Safe.ArgumentNotNull(context, "context");

            var p = new SyncContextPromise<T>(context, that, true);

            that.Then(
                x => p.Resolve(x),
                e => {
                    p.Reject(e);
                    return default(T);
                }
            );
            return p;
        }

        public static AsyncCallback AsyncCallback<T>(this Promise<T> that, Func<IAsyncResult,T> callback) {
            Safe.ArgumentNotNull(that, "that");
            Safe.ArgumentNotNull(callback, "callback");
            return ar => {
                try {
                    that.Resolve(callback(ar));
                } catch (Exception err) {
                    that.Reject(err);
                }
            };
        }
            
        #if NET_4_5

        public static Task<T> GetTask<T>(this IPromise<T> that) {
            Safe.ArgumentNotNull(that, "that");
            var tcs = new TaskCompletionSource<T>();

            that.Last(tcs.SetResult, tcs.SetException, tcs.SetCanceled);

            return tcs.Task;
        }

        #endif
    }
}

