﻿namespace Implab.Diagnostics {
    public static class Extensions {
        public static IPromise<T> EndLogicalOperation<T>(this IPromise<T> promise) {
            Safe.ArgumentNotNull(promise, "promise");
            var op = TraceContext.Instance.DetachLogicalOperation();

            return promise.Anyway(() => {
                TraceContext.Instance.EnterLogicalOperation(op,true);
                TraceLog.EndLogicalOperation();
                TraceContext.Instance.Leave();
            });
        }
    }
}

