﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Diagnostics;

namespace Implab
{
    public static class Safe
    {
        public static void ArgumentMatch(string param, string name, Regex rx) {
            if (rx == null)
                throw new ArgumentNullException("rx");
            if (!rx.IsMatch(param))
                throw new ArgumentException(String.Format("The prameter value must match {0}", rx), name);
        }

        public static void ArgumentNotEmpty(string param, string name) {
            if (String.IsNullOrEmpty(param))
                throw new ArgumentException("The parameter can't be empty", name);
        }

        public static void ArgumentNotEmpty<T>(T[] param, string name) {
            if (param == null || param.Length == 0)
                throw new ArgumentException("The array must be not emty");
        }

        public static void ArgumentNotNull(object param, string name) {
            if (param == null)
                throw new ArgumentNullException(name);
        }

        public static void ArgumentInRange(int arg, int min, int max, string name) {
            if (arg < min || arg > max)
                throw new ArgumentOutOfRangeException(name);
        }

        public static void Dispose<T>(T obj) where T : class
        {
            var disp = obj as IDisposable;
            if (disp != null)
                disp.Dispose();
        }

        [DebuggerStepThrough]
        public static IPromise<T> GuargPromise<T>(Func<T> action) {
            ArgumentNotNull(action, "action");

            var p = new Promise<T>();
            try {
                p.Resolve(action());
            } catch (Exception err) {
                p.Reject(err);
            }

            return p;
        }

        [DebuggerStepThrough]
        public static IPromise<T> GuardPromise<T>(Func<IPromise<T>> action) {
            ArgumentNotNull(action, "action");

            try {
                return action();
            } catch (Exception err) {
                return Promise<T>.ExceptionToPromise(err);
            }
        }
    }
}
