﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Implab {
    public interface IPromise: ICancellable {
        /// <summary>
        /// Check whereather the promise has no more than one dependent promise.
        /// </summary>
        bool IsExclusive {
            get;
        }

        /// <summary>
        /// Тип результата, получаемого через данное обещание.
        /// </summary>
        Type PromiseType { get; }

        /// <summary>
        /// Обещание является выполненым, либо успешно, либо с ошибкой.
        /// </summary>
        bool IsResolved { get; }

        /// <summary>
        /// Обещание было отменено.
        /// </summary>
        bool IsCancelled { get; }

        IPromise Then(Action success, ErrorHandler error, Action cancel);
        IPromise Then(Action success, ErrorHandler error);
        IPromise Then(Action success);

        IPromise Chain(Func<IPromise> chained, ErrorHandler<IPromise> error, Action cancel);
        IPromise Chain(Func<IPromise> chained, ErrorHandler<IPromise> error);
        IPromise Chain(Func<IPromise> chained);

        /// <summary>
        /// Добавляет последнй обработчик в цепочку обещаний, не создает промежуточных обещаний.
        /// </summary>
        /// <param name="success">Success.</param>
        /// <param name="error">Error.</param>
        /// <param name="cancel">Cancel.</param>
        void Last(Action success, ErrorHandler error, Action cancel);
        void Last(Action success, ErrorHandler error);
        void Last(Action success);

        IPromise Error(ErrorHandler error);
        /// <summary>
        /// Обрабатывает либо ошибку, либо результат. Событие отмены не обрабатывается.
        /// </summary>
        /// <param name="handler">Обработчик.</param>
        /// <remarks>После обработке ошибки, она передается дальше.</remarks>
        /// <summary>
        /// Обрабатывает либо ошибку, либо результат, либо отмену обещания.
        /// </summary>
        /// <param name="handler">Обработчик.</param>
        /// <remarks>После обработке ошибки, она передается дальше.</remarks>
        IPromise Anyway(Action handler);
        /// <summary>
        /// Обработчик для регистрации отмены обещания, событие отмены не может быть подавлено.
        /// </summary>
        /// <returns>Новое обещание, связанное с текущим.</returns>
        /// <param name="handler">Обработчик события.</param>
        /// <remarks>Если обработчик вызывает исключение, то оно передается обработчику ошибки, результат работы
        /// которого будет передан связанному обещанию</remarks>
        IPromise Cancelled(Action handler);

        /// <summary>
        /// Преобразует результат обещания к заданному типу и возвращает новое обещание.
        /// </summary>
        IPromise<T> Cast<T>();

        /// <summary>
        /// Синхронизирует текущий поток с обещанием.
        /// </summary>
        void Join();
        /// <summary>
        /// Синхронизирует текущий поток с обещанием.
        /// </summary>
        /// <param name="timeout">Время ожидания, по его истечению возникнет исключение.</param>
        /// <exception cref="TimeoutException">Превышено время ожидания.</exception>
        void Join(int timeout);

    }
}
