﻿using System;
using Implab.Parallels;
using System.Threading;

namespace Implab {
    public class MTComponentContainer : IComponentContainer, IDisposable {
        static readonly MTComponentContainer _appContainer;

        static MTComponentContainer() {
            _appContainer = new MTComponentContainer();
            AppDomain.CurrentDomain.ProcessExit += HandleProcessExit;
        }

        public static MTComponentContainer AppContainer {
            get {
                return _appContainer;
            }
        }

        bool m_disposed;
        readonly MTQueue<IDisposable> m_components = new MTQueue<IDisposable>();

        public void Add(IDisposable item) {
            Safe.ArgumentNotNull(item, "item");
            Thread.MemoryBarrier();
            if (m_disposed) {
                item.Dispose();
            } else {
                m_components.Enqueue(item);
                if (m_disposed && m_components.TryDequeue(out item))
                    item.Dispose();
            }
        }

        public void Dispose() {
            m_disposed = true;
            IDisposable item;
            while (m_components.TryDequeue(out item))
                item.Dispose();
        }

        static void HandleProcessExit (object sender, EventArgs e)
        {
            _appContainer.Dispose();
        }
    }
}

