﻿using System;
using Implab.Components;

namespace Implab.Test.Mock {
    class MockPollingComponent : PollingComponent {
        public MockPollingComponent(TimeSpan interval, Func<Func<ICancellationToken, IPromise>, IPromise> dispatcher, bool initialized) : base(interval, dispatcher, initialized)  {
        }

        public Action MockInit {
            get;
            set;
        }

        public Action<Exception> MockOnError {
            get;
            set;
        }

        public Action<Exception> MockOnCancel {
            get;
            set;
        }

        public Func<IPromise> MockStart {
            get;
            set;
        }

        public Func<IPromise> MockStop {
            get;
            set;
        }

        public Func<ICancellationToken, IPromise> MockTick {
            get;
            set;
        }

        protected override IPromise OnStart() {
            return MockStart != null ? Safe.Run(MockStart).Chain(base.OnStart) : Safe.Run(base.OnStart);
        }

        protected override IPromise OnStop() {
            return MockStop != null ? Safe.Run(MockStop).Chain(base.OnStop) : Safe.Run(base.OnStop);
        }

        protected override void OnInitialize() {
            if (MockInit != null)
                MockInit();
        }

        protected override IPromise OnTick(ICancellationToken cancellationToken) {
            return MockTick != null ? Safe.Run(() => MockTick(cancellationToken)) : Promise.SUCCESS;
        }

        protected override void OnTickCancel(Exception error) {
            if (MockOnCancel != null)
                MockOnCancel(error);
        }

        protected override void OnTickError(Exception error) {
            if (MockOnError != null)
                MockOnError(error);
        }

        public void CallComponentFail(Exception error) {
            Fail(error);
        }
    }
}

