﻿using System;
using Implab.Components;

namespace Implab.Test.Mock {
    class MockRunnableComponent : RunnableComponent {
        public MockRunnableComponent(bool initialized) : base(initialized) {
        }

        public Action MockInit {
            get;
            set;
        }

        public Func<IPromise> MockStart {
            get;
            set;
        }

        public Func<IPromise> MockStop {
            get;
            set;
        }

        protected override IPromise OnStart() {
            return MockStart != null ? Safe.Run(MockStart).Chain(base.OnStart) : Safe.Run(base.OnStart);
        }

        protected override IPromise OnStop() {
            return MockStop != null ? Safe.Run(MockStop).Chain(base.OnStop) : Safe.Run(base.OnStop);
        }

        protected override void OnInitialize() {
            if (MockInit != null)
                MockInit();
        }
    }
}

