﻿using Implab;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Parsing {
    /// <summary>
    /// Выражение, соответсвующее одному символу.
    /// </summary>
    public class SymbolToken : Token {
        int m_value;

        public int Value {
            get { return m_value; }
        }

        public SymbolToken(int value) {
            m_value = value;
        }
        public override void Accept(IVisitor visitor) {
            Safe.ArgumentNotNull(visitor, "visitor");

            visitor.Visit(this);
            
        }

        public override string ToString() {
            return Value.ToString();
        }
    }
}
