﻿using System;
using Implab;
using System.Threading.Tasks;
using Implab.Formats.JSON;
using System.IO;
using System.Text.Json;

namespace MonoPlay {
    class MainClass {


        public static void Main(string[] args) {
            if (args == null)
                throw new ArgumentNullException("args");
            int t1, t2;

            for (int i = 0; i < 2; i++) {
                t1 = Environment.TickCount;
                int elements =0;
                using (var reader = new JSONParser(File.OpenText("/home/sergey/temp/citylots.json"))) {
                    while (reader.Read())
                        elements++;
                }

                t2 = Environment.TickCount;
                Console.WriteLine("attempt {0} done: {1} ms, {2:.00} Mb, {3} GC, Elements: {4}",i+1, t2 - t1, GC.GetTotalMemory(false) / (1024*1024), GC.CollectionCount(0), elements );
            }

            Console.WriteLine("Syste.Text.Json");
            var paraser = new JsonParser();
            for (int i = 0; i < 2; i++) {
                t1 = Environment.TickCount;
                using (var reader = File.OpenText("/home/sergey/temp/citylots.json")) {
                    paraser.Parse(reader);
                }

                t2 = Environment.TickCount;
                Console.WriteLine("attempt {0} done: {1} ms, {2:.00} Mb, {3} GC, ",i+1, t2 - t1, GC.GetTotalMemory(false) / (1024*1024), GC.CollectionCount(0));
            }


        }

    }
}
