﻿using Implab;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Parsing {
    public class Alphabet: AlphabetBase<char> {

        public override int GetSymbolIndex(char symbol) {
            return symbol;
        }

        public override IEnumerable<char> InputSymbols {
            get { return Enumerable.Range(char.MinValue, char.MaxValue).Select(x => (char)x); }
        }

        protected override int MapSize {
            get { return char.MaxValue + 1; }
        }
    }
}
