﻿using System;

namespace Implab.Automaton.RegularExpressions {
    public class RegularDFADefinition<TInput, TTag> : DFATable {

        readonly IAlphabet<TInput> m_alphabet;

        public RegularDFADefinition(IAlphabet<TInput> alphabet) {
            Safe.ArgumentNotNull(alphabet, "aplhabet");

            m_alphabet = alphabet;
        }


        public IAlphabet<TInput> InputAlphabet {
            get {
                return m_alphabet;
            }
        }

        protected override DFAStateDescriptior[] ConstructTransitionTable() {
            if (InputAlphabet.Count != m_alphabet.Count)
                throw new InvalidOperationException("The alphabet doesn't match the transition table");
            
            return base.ConstructTransitionTable();
        }

        /// <summary>
        /// Optimize the specified alphabet.
        /// </summary>
        /// <param name = "dfaTable"></param>
        /// <param name="alphabet">Пустой алфавит, который будет зполнен в процессе оптимизации.</param>
        public void Optimize(IDFATableBuilder<TTag> dfaTable, IAlphabetBuilder<TInput> alphabet) {
            Safe.ArgumentNotNull(alphabet, "alphabet");
            Safe.ArgumentNotNull(dfaTable, "dfaTable");

            Optimize(dfaTable, InputAlphabet, alphabet, new DummyAlphabet(StateCount), new MapAlphabet<int>()); 
        }


    }
}

