﻿namespace Implab.Parsing {
    public class CDFADefinition : DFADefinition {
        readonly CharAlphabet m_alphabet;

        public CharAlphabet Alphabet {
            get { return m_alphabet; }
        }

        public CDFADefinition(CharAlphabet alphabet): base(alphabet.Count) {
            m_alphabet = alphabet;
        }

        public CDFADefinition Optimize() {
            var optimized = new CDFADefinition(new CharAlphabet());

            Optimize(optimized, m_alphabet, optimized.Alphabet);
            return optimized;
        }

        public void PrintDFA() {
            PrintDFA(m_alphabet);
        }
    }
}
