﻿using Implab;
using System;

namespace Implab.Parsing {
    public class EDFADefinition<T> : DFADefinition where T : struct, IConvertible {
        readonly EnumAlphabet<T> m_alphabet;

        public EnumAlphabet<T> Alphabet { 
            get { return m_alphabet; }
        }

        public EDFADefinition(EnumAlphabet<T> alphabet) : base(alphabet.Count) {
            m_alphabet = alphabet;
        }

        public void DefineTransition(int s1, int s2, T input) {
            DefineTransition(s1, s2, m_alphabet.Translate(input));
        }

        public EDFADefinition<T> Optimize() {
            var optimized = new EDFADefinition<T>(new EnumAlphabet<T>());
            Optimize(optimized, m_alphabet, optimized.Alphabet);

            return optimized;
        }

        public void PrintDFA() {
            PrintDFA(m_alphabet);
        }
    }
}
