﻿using System;

namespace Implab.Parsing {
    public class CatToken : BinaryToken {
        public CatToken(Token left, Token right)
            : base(left, right) {
        }

        public override void Accept(IVisitor visitor) {
            Safe.ArgumentNotNull(visitor, "visitor");
            visitor.Visit(this);
        }

        public override string ToString() {
            return String.Format("{0}{1}", FormatToken(Left), FormatToken(Right));
        }

        string FormatToken(Token token) {
            return String.Format(token is AltToken ? "({0})" : "{0}", token);
        }
    }
}
