﻿using System.Threading;
using System;

namespace Implab {
    public class SyncContextPromise<T> : Promise<T> {
        readonly SynchronizationContext m_context;

        public SyncContextPromise(SynchronizationContext context) {
            Safe.ArgumentNotNull(context, "context");
            m_context = context;
        }

        protected override void SignalHandler(HandlerDescriptor handler, int signal) {
            m_context.Post(x => base.SignalHandler(handler, signal), null);
        }
    }
}

