﻿using System;

namespace Implab {
    public class FuncChainTask<TArg,TResult> : FuncChainTaskBase<TResult>, IDeferred<TArg> {
        readonly Func<TArg, IPromise<TResult>> m_task;

        public FuncChainTask(Func<TArg, IPromise<TResult>> task, Func<Exception, IPromise<TResult>> error, Func<Exception, IPromise<TResult>> cancel, bool autoCancellable) : base(error, cancel, autoCancellable){
            m_task = task;
        }

        public void Resolve(TArg value) {
            if (m_task != null && LockCancelation()) {
                try {
                    var operation = m_task(value);
                    operation.On(SetResult, HandleErrorInternal, SetCancelled);
                    CancellationRequested(operation.Cancel);
                } catch (Exception err) {
                    HandleErrorInternal(err);
                }
            }
        }
    }
}