﻿using System;
using System.Reflection;

namespace Implab {
    public class FailedPromise<T> : FailedPromise, IPromise<T> {
        public FailedPromise(Exception error) : base(error) {
        }

        public IPromise<T> On(Action<T> success, Action<Exception> error, Action<Exception> cancel) {
            if (error != null) {
                try {
                    error(RejectReason);  
                    // Analysis disable once EmptyGeneralCatchClause
                } catch {
                }
            }
            return this;
        }

        public IPromise<T> On(Action<T> success, Action<Exception> error) {
            if (error != null) {
                try {
                    error(RejectReason);  
                    // Analysis disable once EmptyGeneralCatchClause
                } catch {
                }
            }
            return this;
        }

        public IPromise<T> On(Action<T> success) {
            return this;
        }

        T IPromise<T>.Join() {
            throw new TargetInvocationException(RejectReason);
        }

        T IPromise<T>.Join(int timeout) {
            throw new TargetInvocationException(RejectReason);
        }


        IPromise<T> IPromise<T>.On(Action success, Action<Exception> error, Action<Exception> cancel) {
            On(success, error, cancel);
            return this;
        }

        IPromise<T> IPromise<T>.On(Action success, Action<Exception> error) {
            On(success, error);
            return this;
        }

        IPromise<T> IPromise<T>.On(Action success) {
            On(success);
            return this;
        }

        IPromise<T> IPromise<T>.On(Action handler, PromiseEventType events) {
            On(handler, events);
            return this;
        }
    }
}

