﻿using System;

namespace Implab {
    public class FuncChainTask<TResult> : FuncChainTaskBase<TResult>, IResolvable {
        readonly Func<IPromise<TResult>> m_task;

        public FuncChainTask(Func<IPromise<TResult>> task, Func<Exception, IPromise<TResult>> error, Func<Exception, IPromise<TResult>> cancel, bool autoCancellable)
            : base(error, cancel, autoCancellable) {
            m_task = task;
        }

        public void Resolve() {
            if (m_task != null && LockCancelation()) {
                try {
                    var operation = m_task();
                    operation.On(SetResult, HandleErrorInternal, HandleCancelInternal);
                    CancellationRequested(operation.Cancel);
                } catch (Exception err) {
                    SetErrorInternal(err);
                }
            }
        }
    }
}