﻿using System;
using System.Runtime.CompilerServices;

namespace Implab {
    public struct PromiseAwaiter : INotifyCompletion {
        readonly IPromise m_promise;

        public PromiseAwaiter(IPromise promise) {
            m_promise = promise;
        }

        public void OnCompleted (Action continuation) {
            if (m_promise != null)
                m_promise.On(continuation, PromiseEventType.All);
        }

        public void GetResult() {
            m_promise.Join();
        }

        public bool IsCompleted {
            get {
                return m_promise.IsFulfilled;
            }
        }
    }
}

