using System;

namespace Implab {
    public class PromiseReaction : IResolvable {
        IDispatcher m_dispatcher;

        Action m_onFulfilledJob;

        Action<Exception> m_onRejectedJob;

        IResolvable m_next;

        public void Reject(Exception error) {
            if (m_onRejectedJob != null) {
                if (m_dispatcher != null)
                    m_dispatcher.Enqueue(() => m_onRejectedJob(error));
                else
                    m_onRejectedJob(error);
            } else {
                m_next.Reject(error);
            }
        }

        public void Resolve() {
            if (m_onRejectedJob != null) {
                if (m_dispatcher != null)
                    m_dispatcher.Enqueue( m_onFulfilledJob);
                else
                    m_onFulfilledJob();
            } else {
                m_next.Resolve();
            }
        }
    }
}