using System;
using System.Threading;

namespace Implab
{
    class PromiseAll : IResolvable {
        int m_count;

        readonly Deferred m_deferred;

        public bool Done {
            get { return m_deferred.Promise.IsResolved; }
        }

        public IPromise ResultPromise {
            get { return m_deferred.Promise; }
        }

        public void AddPromise(IPromise promise) {
            Interlocked.Increment(ref m_count);
        }

        public PromiseAll(Deferred deferred) {
            m_deferred = deferred;
        }

        public void Resolve() {
            if (Interlocked.Decrement(ref m_count) == 0)
                m_deferred.Resolve();
        }

        public void Complete() {
            Resolve();
        }

        public void Reject(Exception error) {
            m_deferred.Reject(error);
        }
    }
}