using System;

namespace Implab {
    /// <summary>
    /// Базовыйй класс для создания обработчиков результов выполнения обещаний.
    /// Данный объект связывает обработчик и обешание, при этом для выполнения
    /// обработчика будет использоваться диспетчер.
    /// </summary>
    abstract class PromiseReaction : IResolvable {
        readonly IDispatcher m_dispatcher;

        protected PromiseReaction(IDispatcher dispatcher) {
            m_dispatcher = dispatcher;
        }

        protected Action FulfilHandler { get; set; }

        protected Action<Exception> RejectHandler { get; set; }

        public void Reject(Exception error) {
            if (RejectHandler == null)
                DefaultReject(error);
            else if (m_dispatcher != null)
                m_dispatcher.Enqueue(RejectHandler, error);
            else
                RejectHandler(error);
        }

        public void Resolve() {
            if (FulfilHandler == null)
                DefaultResolve();
            else if (m_dispatcher != null)
                m_dispatcher.Enqueue(FulfilHandler);
            else
                FulfilHandler();
        }

        protected abstract void DefaultResolve();

        protected abstract void DefaultReject(Exception reason);
    }
}