using System;
using System.Diagnostics;

namespace Implab {
    class PromiseActionReaction : PromiseReaction {

        readonly Deferred m_next;

        public IPromise Promise {
            get { return m_next.Promise; }
        }

        public PromiseActionReaction(Action fulfilled, Action<Exception> rejected, IDispatcher dispatcher) : base(dispatcher) {
            m_next = new Deferred(dispatcher);
            if (fulfilled != null)
                FulfilHandler = PromiseHandler.Create(fulfilled, m_next);

            if (rejected != null)
                RejectHandler = PromiseHandler.Create(rejected, m_next);
        }

        public PromiseActionReaction(Func<IPromise> fulfilled, Func<Exception, IPromise> rejected, IDispatcher dispatcher) : base(dispatcher) {
            m_next = new Deferred(dispatcher);
            if (fulfilled != null)
                FulfilHandler = PromiseHandler.Create(fulfilled, m_next);

            if (rejected != null)
                RejectHandler = PromiseHandler.Create(rejected, m_next);
        }

        public PromiseActionReaction(Action fulfilled, Func<Exception, IPromise> rejected, IDispatcher dispatcher) : base(dispatcher) {
            m_next = new Deferred(dispatcher);
            if (fulfilled != null)
                FulfilHandler = PromiseHandler.Create(fulfilled, m_next);

            if (rejected != null)
                RejectHandler = PromiseHandler.Create(rejected, m_next);
        }

        public PromiseActionReaction(Func<IPromise> fulfilled, Action<Exception> rejected, IDispatcher dispatcher) : base(dispatcher) {
            m_next = new Deferred(dispatcher);
            if (fulfilled != null)
                FulfilHandler = PromiseHandler.Create(fulfilled, m_next);

            if (rejected != null)
                RejectHandler = PromiseHandler.Create(rejected, m_next);
        }

        protected override void DefaultReject(Exception reason) {
            m_next.Reject(reason);
        }

        protected override void DefaultResolve() {
            m_next.Resolve();
        }
    }
}