﻿using System.Threading;
using System;
using Implab.Diagnostics;
using System.Collections.Generic;
using System.Linq;

namespace Implab {
    public static class PromiseExtensions {

        public static IPromise Then(this IPromise that, Action fulfilled, Action<Exception> rejected) {
            var reaction = new PromiseActionReaction(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then(this IPromise that, Action fulfilled, Func<Exception, IPromise> rejected) {
            var reaction = new PromiseActionReaction(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then(this IPromise that, Func<IPromise> fulfilled, Action<Exception> rejected) {
            var reaction = new PromiseActionReaction(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then(this IPromise that, Func<IPromise> fulfilled, Func<Exception, IPromise> rejected) {
            var reaction = new PromiseActionReaction(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then<T>(this IPromise<T> that, Action<T> fulfilled, Action<Exception> rejected) {
            var reaction = new PromiseActionReaction<T>(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then<T>(this IPromise<T> that, Action<T> fulfilled, Func<Exception, IPromise> rejected) {
            var reaction = new PromiseActionReaction<T>(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then<T>(this IPromise<T> that, Func<T, IPromise> fulfilled, Action<Exception> rejected) {
            var reaction = new PromiseActionReaction<T>(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then<T>(this IPromise<T> that, Func<T, IPromise> fulfilled, Func<Exception, IPromise> rejected) {
            var reaction = new PromiseActionReaction<T>(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tout>(this IPromise that, Func<Tout> fulfilled, Func<Exception, Tout> rejected) {
            var reaction = new PromiseFuncReaction<Tout>(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tout>(this IPromise that, Func<Tout> fulfilled, Func<Exception, IPromise<Tout>> rejected) {
            var reaction = new PromiseFuncReaction<Tout>(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tout>(this IPromise that, Func<IPromise<Tout>> fulfilled, Func<Exception, Tout> rejected) {
            var reaction = new PromiseFuncReaction<Tout>(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tout>(this IPromise that, Func<IPromise<Tout>> fulfilled, Func<Exception, IPromise<Tout>> rejected) {
            var reaction = new PromiseFuncReaction<Tout>(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tin, Tout>(this IPromise<Tin> that, Func<Tin, Tout> fulfilled, Func<Exception, Tout> rejected) {
            var reaction = new PromiseFuncReaction<Tin, Tout>(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tin, Tout>(this IPromise<Tin> that, Func<Tin, Tout> fulfilled, Func<Exception, IPromise<Tout>> rejected) {
            var reaction = new PromiseFuncReaction<Tin, Tout>(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tin, Tout>(this IPromise<Tin> that, Func<Tin, IPromise<Tout>> fulfilled, Func<Exception, Tout> rejected) {
            var reaction = new PromiseFuncReaction<Tin, Tout>(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tin, Tout>(this IPromise<Tin> that, Func<Tin, IPromise<Tout>> fulfilled, Func<Exception, IPromise<Tout>> rejected) {
            var reaction = new PromiseFuncReaction<Tin, Tout>(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Catch(this IPromise that, Action<Exception> rejected) {
            return Then(that, null, rejected);
        }

        public static IPromise Catch(this IPromise that, Func<Exception, IPromise> rejected) {
            return Then(that, null, rejected);
        }

        public static IPromise<Tout> Catch<Tout>(this IPromise that, Func<Exception, Tout> rejected) {
            return Then(that, (Func<Tout>)null, rejected);
        }

        public static IPromise<Tout> Catch<Tout>(this IPromise that, Func<Exception, IPromise<Tout>> rejected) {
            return Then(that, (Func<Tout>)null, rejected);
        }

        public static IPromise<Tout> Catch<Tin, Tout>(this IPromise<Tin> that, Func<Exception, Tout> rejected) {
            return Then(that, (Func<Tin, Tout>)null, rejected);
        }

        public static IPromise<Tout> Catch<Tin, Tout>(this IPromise<Tin> that, Func<Exception, IPromise<Tout>> rejected) {
            return Then(that, (Func<Tin, Tout>)null, rejected);
        }
    }
}

