using System;
using System.Diagnostics;

namespace Implab {
    class PromiseHandler {
        public static Action<T> Create<T>(Action<T> handler, Deferred next) {
            Debug.Assert(handler != null);

            return (v) => {
                try {
                    handler(v);
                    next.Resolve();
                } catch (Exception err) {
                    next.Reject(err);
                }
            };
        }

        public static Action<T> Create<T>(Func<T, IPromise> handler, Deferred next) {
            Debug.Assert(handler != null);

            return (v) => {
                try {
                    next.Resolve(handler(v));
                } catch (Exception err) {
                    next.Reject(err);
                }
            };
        }

        public static Action<T> Create<T, T2>(Func<T, T2> handler, Deferred<T2> next) {
            Debug.Assert(handler != null);

            return (v) => {
                try {
                    next.Resolve(handler(v));
                } catch (Exception err) {
                    next.Reject(err);
                }
            };
        }

        public static Action<T> Create<T, T2>(Func<T, IPromise<T2>> handler, Deferred<T2> next) {
            Debug.Assert(handler != null);
            return (v) => {
                try {
                    next.Resolve(handler(v));
                } catch (Exception err) {
                    next.Reject(err);
                }
            };
        }

        public static Action Create(Action handler, Deferred next) {
            Debug.Assert(handler != null);

            return () => {
                try {
                    handler();
                    next.Resolve();
                } catch (Exception err) {
                    next.Reject(err);
                }
            };
        }

        public static Action Create(Func<IPromise> handler, Deferred next) {
            Debug.Assert(handler != null);

            return () => {
                try {
                    next.Resolve(handler());
                } catch (Exception err) {
                    next.Reject(err);
                }
            };
        }

        public static Action Create<T2>(Func<T2> handler, Deferred<T2> next) {
            Debug.Assert(handler != null);

            return () => {
                try {
                    next.Resolve(handler());
                } catch (Exception err) {
                    next.Reject(err);
                }
            };
        }

        public static Action Create<T2>(Func<IPromise<T2>> handler, Deferred<T2> next) {
            Debug.Assert(handler != null);
            return () => {
                try {
                    next.Resolve(handler());
                } catch (Exception err) {
                    next.Reject(err);
                }
            };
        }
    }
}