using System;
using System.Reflection;
using System.Runtime.ExceptionServices;

namespace Implab {
    public static class ExceptionHelpers {
        public static void Rethrow(this Exception that) {
            ExceptionDispatchInfo.Capture(that).Throw();
        }

        public static void ThrowInvocationException(this Exception that) {
            if (that is OperationCanceledException)
                throw new OperationCanceledException("Operation cancelled", that);
            else
                throw new TargetInvocationException(that);
        }
    }
}