﻿using System.Threading;

namespace Implab {
    public class SyncContextPromise<T> : Promise<T> {
        readonly SynchronizationContext m_context;

        public SyncContextPromise(SynchronizationContext context) {
            Safe.ArgumentNotNull(context, "context");
            m_context = context;
        }

        public SyncContextPromise(SynchronizationContext context, IPromise parent)
            : base(parent) {
            Safe.ArgumentNotNull(context, "context");
            m_context = context;
        }
        protected override void InvokeHandler(HandlerDescriptor handler) {
            m_context.Post(x => base.InvokeHandler(handler),null);
        }
    }
}

