﻿using Implab;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab {
    /// <summary>
    /// Обертка для создания <c>IEqualityComparer</c> с использованием делегатов или лямда-выражений.
    /// </summary>
    /// <typeparam name="T">Тип сравниваемых значений</typeparam>
    public class CustomEqualityComparer<T> : IEqualityComparer<T> {
        Func<T, T, bool> m_equals;
        Func<T, int> m_hash;

        /// <summary>
        /// Создает новый объект с указанными функциями сравнения на раветво и получения хеш-кода.
        /// </summary>
        /// <param name="equality">Функция проверки на равенство</param>
        /// <param name="hash">Функция получения хешкода</param>
        public CustomEqualityComparer(Func<T, T, bool> equality, Func<T, int> hash) {
            Safe.ArgumentNotNull(equality, "equality");
            Safe.ArgumentNotNull(hash, "hash");
            m_hash = hash;
            m_equals = equality;
        }

        /// <summary>
        /// Сравнивает два знаечния на ревенство.
        /// </summary>
        /// <param name="x"></param>
        /// <param name="y"></param>
        /// <returns>Результат сравнения на равенство</returns>
        public bool Equals(T x, T y) {
            return m_equals(x,y);
        }

        /// <summary>
        /// Получает хеш-код для указанного значения.
        /// </summary>
        /// <param name="obj"></param>
        /// <remarks>Равные знаечния *должны* иметь одинаковый хеш-код.</remarks>
        /// <returns>Хеш-код</returns>
        public int GetHashCode(T obj) {
            return m_hash(obj);
        }
    }
}
